(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22879,        538]
NotebookOptionsPosition[     21641,        507]
NotebookOutlinePosition[     22113,        525]
CellTagsIndexPosition[     22070,        522]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Model", "Subsection"]], "Subsection",
 CellChangeTimes->{{3.925812292580725*^9, 3.9258122944676633`*^9}, {
  3.954492085434026*^9, 
  3.9544920858968887`*^9}},ExpressionUUID->"ec59c9da-7665-4685-8eea-\
9f2eac794c0f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"H_", ",", "L_", ",", "mu_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"mu", "*", "H"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "mu"}], ")"}], "*", "L"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DemandH", "[", 
    RowBox[{"x_", ",", "\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}],
    ":=", 
   RowBox[{"1", "-", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", 
      RowBox[{"x", "-", "H"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DemandL", "[", 
    RowBox[{"x_", ",", "\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}],
    ":=", 
   RowBox[{"1", "-", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", 
      RowBox[{"x", "-", "L"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Delta", "[", 
    RowBox[{"x_", ",", "\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}],
    ":=", 
   RowBox[{
    RowBox[{"DemandH", "[", 
     RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], "]"}], 
    "-", 
    RowBox[{"DemandL", "[", 
     RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], "]"}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EDemand", "[", 
    RowBox[{"x_", ",", "\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}],
    ":=", 
   RowBox[{
    RowBox[{"mu", "*", 
     RowBox[{"DemandH", "[", 
      RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], "]"}]}], 
    "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "mu"}], ")"}], "*", 
     RowBox[{"DemandL", "[", 
      RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RealSpread", "[", 
    RowBox[{"x_", ",", "\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}],
    ":=", 
   RowBox[{"x", "-", 
    RowBox[{"m", "[", 
     RowBox[{"H", ",", "L", ",", "mu"}], "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"H", "-", "L"}], ")"}], "*", 
     RowBox[{"Delta", "[", 
      RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], "]"}], 
     "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "mu"}], ")"}], "*", "mu", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"EDemand", "[", 
        RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], "]"}], 
       "^", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"equilibriumprice", "[", 
    RowBox[{"\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}], ":=", 
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"Part", "[", 
      RowBox[{"x", "/.", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RealSpread", "[", 
           RowBox[{"x", ",", "\[Sigma]", ",", "H", ",", "L", ",", "mu"}], 
           "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{
            RowBox[{"m", "[", 
             RowBox[{"H", ",", "L", ",", "mu"}], "]"}], "+", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{"H", "-", "L"}], ")"}]}]}]}], "}"}]}], "]"}]}], "]"}], 
     ",", "H"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"equilibriumspread", "[", 
    RowBox[{"\[Sigma]_", ",", "H_", ",", "L_", ",", "mu_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"equilibriumprice", "[", 
     RowBox[{"\[Sigma]", ",", "H", ",", "L", ",", "mu"}], "]"}], " ", "-", 
    " ", 
    RowBox[{"m", "[", 
     RowBox[{"H", ",", "L", ",", "mu"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.925817554897291*^9, 3.9258175797863817`*^9}, {
  3.954491970854909*^9, 3.9544920604261065`*^9}, {3.9544921165490475`*^9, 
  3.9544921205048895`*^9}, {3.9544926974566183`*^9, 3.9544927105457907`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"d9830591-7db6-435a-a97c-e714dc55d153"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphs", "Subsection",
 CellChangeTimes->{{3.9544920756105824`*^9, 
  3.954492076978815*^9}},ExpressionUUID->"122a8cf9-df01-4ff1-980c-\
10dc23e1d284"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"equilibriumspread", "[", 
      RowBox[{"\[Sigma]", ",", "4", ",", "0", ",", "0.5"}], "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Sigma]", ",", "1", ",", "9"}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", " ", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Liquidity Shock (\[Sigma])\>\"", " ", ",", 
       "\"\<Quoted spread (\!\(\*OverscriptBox[\(QS\), \(_\)]\))\>\""}], 
      "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black"}], "}"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9030030719733157`*^9, 3.903003086619667*^9}, {
  3.9030031988727036`*^9, 3.903003274227916*^9}, {3.9030033152478533`*^9, 
  3.9030033409058337`*^9}, {3.903003386883867*^9, 3.903003387053177*^9}, {
  3.903003550348344*^9, 3.9030036858538675`*^9}, {3.9030059002820654`*^9, 
  3.9030059034636345`*^9}, {3.925814941597598*^9, 3.925814989721121*^9}, {
  3.925970906709663*^9, 3.9259709180016403`*^9}, {3.954492733614098*^9, 
  3.954492733983136*^9}, {3.954492813162369*^9, 3.9544928141786213`*^9}, {
  3.9544929623495035`*^9, 3.9544929898424525`*^9}, {3.954493021405553*^9, 
  3.954493056219412*^9}, {3.9544930928737125`*^9, 3.95449309309036*^9}, {
  3.954493169988948*^9, 3.954493171981538*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"f7242087-56de-462e-8da1-8828a705e810"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJwV1Xk4lF0bAHBLIUpS2RKmV71EIpWP1H0oVPY1jZLshKhe2pUlsr0UmmhR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       "]]},
     Annotation[#, "Charting`Private`Tag$18542#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1.0000000000000022`, 0.3628198823196617},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"Quoted spread (\\!\\(\\*OverscriptBox[\\(QS\\), \\(_\\)]\\))\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"Liquidity Shock (\[Sigma])\"", HoldForm], TraditionalForm], 
     None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Large,
  LabelStyle->Directive[Large],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1, 9}, {0.3628198823196609, 1.9997464251233503`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9030030674252152`*^9, 3.903003090424348*^9}, {
   3.9030032013931465`*^9, 3.903003276804819*^9}, 3.9030033439847536`*^9, 
   3.9030033902261295`*^9, 3.9030035539457664`*^9, 3.9030036890181503`*^9, 
   3.9030059073539715`*^9, {3.9061119498829126`*^9, 3.9061119688188767`*^9}, 
   3.9112130078518906`*^9, 3.9258149937574873`*^9, 3.925815216485846*^9, 
   3.9258157165266485`*^9, 3.9258167318853345`*^9, 3.9258168083491845`*^9, 
   3.9258169804125443`*^9, 3.9258170556427326`*^9, 3.9258177333506975`*^9, 
   3.925817795625412*^9, 3.92581862920182*^9, 3.925970871746417*^9, 
   3.925970922918092*^9, 3.9307225128953342`*^9, {3.954492730815549*^9, 
   3.9544927345829906`*^9}, {3.9544927929081526`*^9, 3.9544928148847437`*^9}, 
   3.954492990889988*^9, {3.9544930219057226`*^9, 3.9544930565586247`*^9}, 
   3.9544930933931046`*^9, 3.9544931733657227`*^9, 3.9693646725911775`*^9, 
   3.969364839751938*^9, 3.9719269250499334`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"127f8347-5bdb-46a2-8b44-776cd092ecd1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"equilibriumspread", "[", 
      RowBox[{"5", ",", 
       RowBox[{"2", "+", 
        RowBox[{"0.5", "*", "d"}]}], ",", 
       RowBox[{"2", "-", 
        RowBox[{"0.5", "*", "d"}]}], ",", "0.5"}], "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "0", ",", "8"}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", " ", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Asset Volatility (\!\(\*SubscriptBox[\(\[CapitalDelta]\), \
\(v\)]\))\>\"", " ", ",", 
       "\"\<Quoted spread (\!\(\*OverscriptBox[\(QS\), \(_\)]\))\>\""}], 
      "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black"}], "}"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.925815057186322*^9, 3.925815090272411*^9}, {
   3.925818081784074*^9, 3.9258180969735017`*^9}, {3.9258184627977705`*^9, 
   3.925818492102688*^9}, {3.9259709330456986`*^9, 3.9259709419239044`*^9}, {
   3.954492958509204*^9, 3.9544930066280375`*^9}, 3.9544931182320766`*^9, {
   3.9544931777981715`*^9, 3.954493179041192*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"08cbf6fd-1b9a-4501-85c1-cfab70f6ae8a"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJwd0gk4lNsbAPDPUjNXXQySdb7sZZnkihLznqg7QvcyFEVStnIJqXsttyzh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       "]]},
     Annotation[#, "Charting`Private`Tag$20217#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"Quoted spread (\\!\\(\\*OverscriptBox[\\(QS\\), \\(_\\)]\\))\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"Asset Volatility (\\!\\(\\*SubscriptBox[\\(\[CapitalDelta]\\), \
\\(v\\)]\\))\"", HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Large,
  LabelStyle->Directive[Large],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 8}, {0., 3.026517519565475}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9258150715560474`*^9, 3.9258152216347065`*^9, 3.9258157228290715`*^9, 
   3.9258167380757427`*^9, 3.9258169883336177`*^9, 3.925817088929037*^9, 
   3.9258178006082854`*^9, 3.9258181073521943`*^9, {3.9258184866906023`*^9, 
   3.92581849491547*^9}, 3.9258186331632547`*^9, 3.9259709446832805`*^9, 
   3.9544930072662935`*^9, 3.954493179774816*^9, 3.969364674951639*^9, 
   3.969364842068901*^9, 3.9719269275876436`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"f249af8f-8fc5-4835-80f2-d1123d58eeae"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig_2_a.pdf\>\"", ",", "Graph1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fig_2_b.pdf\>\"", ",", "Graph2"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.954493261965366*^9, 3.9544932628071184`*^9}, {
  3.9544933651642137`*^9, 3.9544933818964205`*^9}, {3.9548206724628563`*^9, 
  3.9548206802402334`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"a7c00165-7bbc-4713-9e1e-c091be14745c"]
}, Open  ]]
},
WindowSize->{949, 461},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
TaggingRules-><|"TryRealOnly" -> False|>,
Magnification:>0.9 Inherited,
FrontEndVersion->"13.2 pour Microsoft Windows (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"fe7bfa85-4679-4753-8ff4-0acdf20d3e04"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 240, 4, 48, "Subsection",ExpressionUUID->"ec59c9da-7665-4685-8eea-9f2eac794c0f"],
Cell[823, 28, 4215, 122, 208, "Input",ExpressionUUID->"d9830591-7db6-435a-a97c-e714dc55d153"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5075, 155, 156, 3, 48, "Subsection",ExpressionUUID->"122a8cf9-df01-4ff1-980c-10dc23e1d284"],
Cell[CellGroupData[{
Cell[5256, 162, 1756, 35, 109, "Input",ExpressionUUID->"f7242087-56de-462e-8da1-8828a705e810"],
Cell[7015, 199, 6692, 129, 353, "Output",ExpressionUUID->"127f8347-5bdb-46a2-8b44-776cd092ecd1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13744, 333, 1538, 35, 109, "Input",ExpressionUUID->"08cbf6fd-1b9a-4501-85c1-cfab70f6ae8a"],
Cell[15285, 370, 5691, 116, 353, "Output",ExpressionUUID->"f249af8f-8fc5-4835-80f2-d1123d58eeae"]
}, Open  ]],
Cell[20991, 489, 634, 15, 103, "Input",ExpressionUUID->"a7c00165-7bbc-4713-9e1e-c091be14745c"]
}, Open  ]]
}
]
*)

